$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var thisdir = params[1] + '/' + params[2];  //get subfolder (if any) that page is running from and page name
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }

    // On page load: datatable
    var table_frameworks = $('#table_frameworks').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/framework/get_frameworks/f/' + framework_id,
            "data": function (d) {
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "framework_name"},
            {"data": "framework_type"},
            {"data": "timezone"},
            {"data": "survey_url"},
            {"data": "portal_url"},
            {"data": "framework_style"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });


    var table_framework_surveys = $('#table_framework_surveys').DataTable({
        //"ajax": "./includes/frameworkdata.php?job=get_frameworks",
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/framework/get_surveys/f/' + framework_id,
            "data": function (d) {
                d.framework_id = $('#framework option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "framework_name"},
            {"data": "survey_id"},
            {"data": "survey_type"},
            {"data": "survey_name"},
            {"data": "send_invite"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });

    var table_respondent_attributes = $('#table_respondent_attributes').DataTable({
        //"ajax": "./includes/frameworkdata.php?job=get_frameworks",
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/framework/get_respondent_attributes/f/' + framework_id,
            "data": function (d) {
                d.framework_id = $('#framework option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "framework_name"},
            {"data": "attribute_code"},
            {"data": "attribute_number"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });


    var table_framework_reports = $('#table_framework_reports').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/framework/get_framework_reports/f/' + framework_id,
            "data": function (d) {
                d.framework_id = $('#framework option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "framework_name"},
            {"data": "report_name"},
            {"data": "script_name"},
            {"data": "file_output"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });

    var table_framework_question_codes = $('#table_framework_question_codes').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/framework/get_framework_question_codes/f/' + framework_id,
            "data": function (d) {
                d.framework_id = $('#framework option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "framework_name"},
            {"data": "code"},
            {"data": "value"},
            {"data": "type"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });

    $('#table_audit').DataTable({
        "order": [[0, "desc"]],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
        ],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });

    $('#table_debug').DataTable({
        "order": [[0, "desc"]],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]}
        ],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });
    /*
     * ERROR HANDLING
     */

    $.fn.dataTable.ext.errMode = 'none';

    $('#table_frameworks')
        .on('error.dt', function (e, settings, techNote, message) {
            console.log('An error has been reported by DataTables: ', message);
        })
        .DataTable();


// On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            uname: {
                required: true,
                //checkUserName: true
            },
            password: {
                minlength: 3
            },
            confirm_password: {
                minlength: 3,
                equalTo: "#password"
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });
    var form_framework = $('#form_framework');
    form_framework.validate();
    var form_reports = $('#form_reports');
    form_reports.validate();
    var form_survey = $('#form_survey');
    form_survey.validate();
    var form_resp_attributes = $('#form_resp_attributes');
    form_resp_attributes.validate();
    var form_question_codes = $('#form_question_codes');
    form_question_codes.validate();

    //manually fade out alert (from bulk import)
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 3000);

// Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

// Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

// Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

// Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

// Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

// Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
// Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
// Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

// Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }

    $("#addFrameworkSurvey").click(function () {
        $("#framework_surveys").append("<tr><td>row</td><td><input type='text'></td></tr>");
    });

// Add framework button
    $(document).on('click', '#add_framework', function (e) {
        e.preventDefault();
        // Get round info.  should have passed in framework_id as data id
        //show_loading_message();
        var request = $.ajax({
            url: '/' + subdir + '/framework/get_framework_types/f/' + framework_id,
            cache: false,
            data: 'id=1',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#form_framework').show();
                $('#form_survey').hide();
                $('#form_reports').hide();
                $('#form_resp_attributes').hide();
                $('#form_question_codes').hide();
                $('.lightbox_content h2').text('Add Framework');
                $('#form_framework button').html('Add Framework <i class="icon-arrow-right14 position-right"></i>');
                $('#form_framework').attr('class', 'form add');
                $('#form_framework .field_container label.error').hide();
                $('#form_framework .field_container').removeClass('valid').removeClass('error');
                $('#form_framework #framework_name').val('');
                $('#form_framework #framework_code').val('');
                $('#form_framework #framework_admin_name').val('');
                $('#form_framework #framework_admin_email').val('');
                $('#form_framework #active').val(0);
                
                $('#form_framework #leadgen_url').val('');

                $('#form_framework #user_management').val(0);
                $('#form_framework #respondent_user_management').val(0);
                $('#form_framework #consolidate_emails').val(0);
                $('#form_framework #show_reports').val(0);
                $('#form_framework #send_weekends').val(0);
                $('#form_framework #participant_attributes').val(0);
                $('#form_framework #user_reports').val(0);
                $('#form_framework #use_reporting_groups').val(0);
                $('#form_framework #participant_gender').val(0);
                $('#form_framework #dummy_emails').val(0);

                $('#form_framework #deidentify_resp').val(0);
                $('#form_framework #deidentify_part').val(0);
                $('#form_framework #deidentify_days').val(30);
                $('#form_framework #deidentify_name').val(0);
                $('#form_framework #add_opt_out').val(0);
                $('#form_framework #opt_out_footer').val('');

                $('#form_framework #respondent_management').val(0);
                $('#form_framework #generate_reports').val(0);
                $('#form_framework #email_reports').val(0);
                $('#form_framework #use_open_tracking').val(0);
                $('#form_framework #embed_local_images').val(0);

                $('#form_framework #send_mail').val(0);
                $('#form_framework #max_emails').val(10);
                $('#form_framework #use_smtp').val(0);
                $('#form_framework #start_time').val(0);
                $('#form_framework #default_bounce').val('');

                $('#form_framework #timezone').val('Australia/Melbourne');
                $('#form_framework #framework_style').val('');
                $('#form_framework #framework_logo').val('');
                $('#form_framework #framework_user_logo').val('');
                $('#form_framework #framework_user_icon').val('');

                
                $('#form_framework #use_sms').val(0);
                $('#form_framework #sms_invites').val(0);
                $('#form_framework #sms_reminders').val(0);

                $('#form_framework #framework_type').prop("disabled", false);
                $('#form_framework #framework_type').empty();
                $.each(output.data[0].framework_types, function (key, val) {
                    $('#form_framework #framework_type').append($('<option>', {
                        value: val[0],
                        text: val[1]
                    }));
                });
                $('#form_framework #parent_framework_id').empty();
                $('#form_framework #parent_framework_id').append($('<option>', {value: 0, text: "None"}));
                $.each(output.data[0].frameworks, function (key, val) {
                    $('#form_framework #parent_framework_id').append($('<option>', {
                        value: val['id'],
                        text: val['name']
                    }));
                });

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed 1', 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed 2: ' + textStatus, 'warning');
        });
    });

// Add framework submit form
    $(document).on('submit', '#form_framework.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_framework.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_framework').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');

            var request = $.ajax({
                url: '/' + subdir + '/framework/add_framework/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Framework added successfully - IMPORTANT: please update the survey and reports information now", 'success');
                    $('#table_frameworks').DataTable().ajax.reload(function () {});
                } else {
                    hide_loading_message();
                    show_message(output.result, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

// Edit framework button
    $(document).on('click', '.function_edit a', function (e) {
        e.preventDefault();
        // Get company information from database
        //show_loading_message();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/framework/get_framework/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#form_framework').show();
                $('#form_survey').hide();
                $('#form_reports').hide();
                $('#form_resp_attributes').hide();
                $('#form_question_codes').hide();
                var framework_id = output.data[0].id;
                $('.lightbox_content h2').text('Edit Framework');
                $('#form_framework button').html('Edit Framework <i class="icon-arrow-right14 position-right"></i>');
                $('#form_framework').attr('class', 'form edit');
                $('#form_framework').attr('data-id', id);
                $('#form_framework').attr('data-name', output.data[0].framework_name);
                $('#form_framework .field_container label.error').hide();
                $('#form_framework .field_container').removeClass('valid').removeClass('error');
                $('#form_framework #framework_name').val(output.data[0].framework_name);
                $('#form_framework #framework_code').val(output.data[0].code);
                $('#form_framework #framework_admin_name').val(output.data[0].framework_admin_name);
                $('#form_framework #framework_admin_email').val(output.data[0].framework_admin_email);
                $('#form_framework #active').val(output.data[0].active);

                $('#form_framework #user_management').val(output.data[0].user_management);
                $('#form_framework #respondent_user_management').val(output.data[0].respondent_user_management);
                $('#form_framework #consolidate_emails').val(output.data[0].consolidate_emails);

                $('#form_framework #parent_framework_id').empty();
                $('#form_framework #parent_framework_id').append($('<option>', {value: 0, text: "None"}));
                $.each(output.data[0].frameworks, function (key, val) {
                    var isSelected = false;
                    if (val['id'] == output.data[0].parent_framework_id) {
                        isSelected = true;
                    }
                    $('#form_framework #parent_framework_id').append($('<option>', {
                        value: val['id'],
                        text: val['name'],
                        selected: isSelected
                    }));
                });

                $('#form_framework #show_reports').val(output.data[0].show_reports);
                $('#form_framework #send_weekends').val(output.data[0].send_weekends);
                $('#form_framework #participant_attributes').val(output.data[0].participant_attributes);
                $('#form_framework #user_reports').val(output.data[0].user_reports);
                $('#form_framework #use_reporting_groups').val(output.data[0].use_reporting_groups);
                $('#form_framework #participant_gender').val(output.data[0].participant_gender);
                $('#form_framework #dummy_emails').val(output.data[0].dummy_emails);
                $('#form_framework #default_bounce').val(output.data[0].default_bounce);

                $('#form_framework #timezone').val(output.data[0].timezone);
                $('#form_framework #framework_style').val(output.data[0].framework_style);
                $('#form_framework #framework_logo').val(output.data[0].framework_logo);
                $('#form_framework #framework_user_logo').val(output.data[0].framework_user_logo);
                $('#form_framework #framework_user_icon').val(output.data[0].framework_user_icon);
                $('#form_framework #survey_url').val(output.data[0].survey_url);
                $('#form_framework #portal_url').val(output.data[0].portal_url);
                $('#form_framework #leadgen_url').val(output.data[0].leadgen_url);

                $('#form_framework #deidentify_resp').val(output.data[0].deidentify_resp);
                $('#form_framework #deidentify_part').val(output.data[0].deidentify_part);
                $('#form_framework #deidentify_days').val(output.data[0].deidentify_days);
                $('#form_framework #deidentify_name').val(output.data[0].deidentify_name);
                $('#form_framework #add_opt_out').val(output.data[0].add_opt_out);
                $('#form_framework #opt_out_footer').val(output.data[0].opt_out_footer);

                $('#form_framework #respondent_management').val(output.data[0].respondent_management);
                $('#form_framework #generate_reports').val(output.data[0].generate_reports);
                $('#form_framework #email_reports').val(output.data[0].email_reports);
                $('#form_framework #use_open_tracking').val(output.data[0].use_open_tracking);
                $('#form_framework #embed_local_images').val(output.data[0].embed_local_images);

                $('#form_framework #send_mail').val(output.data[0].send_mail);
                $('#form_framework #max_emails').val(output.data[0].max_emails);
                $('#form_framework #use_smtp').val(output.data[0].use_smtp);
                $('#form_framework #start_time').val(output.data[0].start_time);

                
                $('#form_framework #use_sms').val(output.data[0].use_sms);
                $('#form_framework #sms_invites').val(output.data[0].sms_invites);
                $('#form_framework #sms_reminders').val(output.data[0].sms_reminders);


                $('#form_framework #framework_type').empty();
                $.each(output.data[0].framework_types, function (key, val) {
                    var isSelected = false;
                    if (val[0] == output.data[0].framework_type_id) {
                        isSelected = true;
                    }
                    $('#form_framework #framework_type').append($('<option>', {
                        value: val[0],
                        text: val[1],
                        selected: isSelected
                    }));
                    $('#form_framework #framework_type').prop("disabled", true);
                });

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

    $(document).on('submit', '#form_framework.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_framework.valid() == true) {
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_framework').attr('data-id');
            var form_data = $('#form_framework').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var request = $.ajax({
                url: '/' + subdir + '/framework/edit_framework/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id':id}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_frameworks').DataTable().ajax.reload(function () {
                        hide_loading_message();
                        show_message("Framework edited successfully.", 'success');
                    }, true);
                } else if (output['result'] == 'taken') {
                    $('#form_framework #uname').val('');
                    hide_loading_message();
                    show_lightbox();
                    alert(output['message']);

                } else {
                    hide_loading_message();
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

// Edit framework button
    $(document).on('click', '.function_edit_survey a', function (e) {
        e.preventDefault();
        // Get company information from database
        //show_loading_message();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/framework/get_survey/f/' + framework_id,
            cache: false,
            data: 'id=' + id + '&framework_id=' + $('#framework option:selected').val(),
            dataType: 'json',
            // contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#form_framework').hide();
                $('#form_survey').show();
                $('#form_reports').hide();
                $('#form_resp_attributes').hide();
                $('#form_question_codes').hide();
                $('.lightbox_content h2').text('Edit Framework Survey');
                $('#form_survey button').html('Edit Survey <i class="icon-arrow-right14 position-right"></i>');
                $('#form_survey').attr('class', 'form edit');
                $('#form_survey').attr('data-id', id);
                $('#form_survey').attr('data-name', output.data[0].framework_name);
                $('#form_survey .field_container label.error').hide();
                $('#form_survey .field_container').removeClass('valid').removeClass('error');
                $('#form_survey #survey_id').val(output.data[0].survey_id);
                $('#form_survey #survey_name').val(output.data[0].survey_name);
                $('#form_survey #survey_type').val(output.data[0].survey_type);

                $('#form_survey #send_invite').empty();
                $.each(output.data[0].statuses, function (key, val) {
                    var isSelected = false;
                    if (key == output.data[0].send_invite) {
                        isSelected = true;
                    }
                    $('#form_survey #send_invite').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });
                $('#form_survey #consolidate_reminders').empty();
                $.each(output.data[0].statuses, function (key, val) {
                    var isSelected = false;
                    if (key == output.data[0].consolidate_reminders) {
                        isSelected = true;
                    }
                    $('#form_survey #consolidate_reminders').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });
                $('#form_survey #is_repeatable').empty();
                $.each(output.data[0].statuses, function (key, val) {
                    var isSelected = false;
                    if (key == output.data[0].is_repeatable) {
                        isSelected = true;
                    }
                    $('#form_survey #is_repeatable').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });

                $('#form_survey #bcc_invite').empty();
                $.each(output.data[0].statuses, function (key, val) {
                    var isSelected = false;
                    if (key == output.data[0].bcc_invite) {
                        isSelected = true;
                    }
                    $('#form_survey #bcc_invite').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });

                $('#form_survey #bcc_reminder').empty();
                $.each(output.data[0].statuses, function (key, val) {
                    var isSelected = false;
                    if (key == output.data[0].bcc_reminder) {
                        isSelected = true;
                    }
                    $('#form_survey #bcc_reminder').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });

                $('#form_survey #bcc_invite').empty();
                $.each(output.data[0].statuses, function (key, val) {
                    var isSelected = false;
                    if (key == output.data[0].bcc_invite) {
                        isSelected = true;
                    }
                    $('#form_survey #bcc_invite').append($('<option>', {
                        value: key,
                        text: val,
                        selected: isSelected
                    }));
                });

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

// Edit survey submit form
    $(document).on('submit', '#form_survey.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_survey.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_survey').attr('data-id');
            var form_data = $('#form_survey').serialize();
            var request = $.ajax({
                url: '/' + subdir + '/framework/edit_survey/f/' + framework_id,
                cache: false,
                // data: form_data + '&id=' + id + '&framework_id=' + $('#framework option:selected').val(),
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'framework_id': $('#framework option:selected').val()}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Survey edited successfully.", 'success');
                    $('#table_framework_surveys').DataTable().ajax.reload(function () {
                    }, true);
                } else if (output['result'] == 'taken') {
                    $('#form_framework #uname').val('');
                    //$('#form_framework #uname-error').removeClass('valid');  $('.nav').find('a.current').parent()
                    hide_loading_message();
                    show_lightbox();
                    alert(output['message']);

                } else {
                    hide_loading_message();
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });


// Add resp attribute button
    $(document).on('click', '#add_resp_attributes', function (e) {
        e.preventDefault();
        $('#form_framework').hide();
        $('#form_survey').hide();
        $('#form_reports').hide();
        $('#form_resp_attributes').show();
        $('#form_question_codes').hide();
        $('.lightbox_content h2').text('Add Respondent Attribute');
        $('#form_resp_attributes button').html('Add Attribute <i class="icon-arrow-right14 position-right"></i>');
        $('#form_resp_attributes').attr('class', 'form add');
        $('#form_resp_attributes .field_container label.error').hide();
        $('#form_resp_attributes .field_container').removeClass('valid').removeClass('error');
        $('#form_resp_attributes #attribute_code').val('');
        $('#form_resp_attributes #attribute_value').val('');

        hide_loading_message();
        show_lightbox();
    });

// Add resp attribute submit form
    $(document).on('submit', '#form_resp_attributes.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_resp_attributes.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_resp_attributes').serialize();

            var request = $.ajax({
                url: '/' + subdir + '/framework/add_respondent_attribute/f/' + framework_id,
                cache: false,
                // data: form_data + '&id=1' + '&framework_id=' + $('#framework option:selected').val(),
                data: form_data + '&' + $.param({'framework_id': $('#framework option:selected').val()}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Attribute added successfully", 'success');
                    $('#table_respondent_attributes').DataTable().ajax.reload(function () {
                    }, true);
                } else {
                    hide_loading_message();
                    show_message(output.result, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

// Edit resp attributes button
    $(document).on('click', '.function_edit_respondent_attribute a', function (e) {
        e.preventDefault();
        // Get company information from database
        //show_loading_message();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/framework/get_respondent_attribute/f/' + framework_id,
            cache: false,
            data: 'id=' + id + '&framework_id=' + $('#framework option:selected').val(),
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#form_framework').hide();
                $('#form_survey').hide();
                $('#form_reports').hide();
                $('#form_resp_attributes').show();
                $('#form_question_codes').hide();
                $('.lightbox_content h2').text('Edit Respondent Attribute');
                $('#form_resp_attributes button').html('Edit Respondent Attribute <i class="icon-arrow-right14 position-right"></i>');
                $('#form_resp_attributes').attr('class', 'form edit');
                $('#form_resp_attributes').attr('data-id', id);
                $('#form_resp_attributes .field_container label.error').hide();
                $('#form_resp_attributes .field_container').removeClass('valid').removeClass('error');
                $('#form_resp_attributes #attribute_code').val(output.data[0].attribute_code);
                $('#form_resp_attributes #attribute_number').val(output.data[0].attribute_number);

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

// Edit survey submit form
    $(document).on('submit', '#form_resp_attributes.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_resp_attributes.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_resp_attributes').attr('data-id');
            var form_data = $('#form_resp_attributes').serialize();
            var request = $.ajax({
                url: '/' + subdir + '/framework/edit_respondent_attribute/f/' + framework_id,
                cache: false,
                // data: form_data + '&id=' + id + '&framework_id=' + $('#framework option:selected').val(),
                data: form_data + '&' + $.param({'id':id}) + '&' + $.param({'framework_id': $('#framework option:selected').val()}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Attribute edited successfully.", 'success');
                    $('#table_respondent_attributes').DataTable().ajax.reload(function () {
                    }, true);
                } else {
                    hide_loading_message();
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

//delete respondent attribute
    $(document).on('click', '.function_delete_respondent_attribute a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var number = $(this).data('number');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete '" + number + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/framework/delete_respondent_attribute/f/' + framework_id,
                        cache: false,
                        // data: $.param({'id': id}) + '&' + $.param({'csrf_token': csrf_token}) + '&' + $.param({'framework_id': $('#framework option:selected').val()}),
                        data: {
                            id: id,
                            csrf_token: csrf_token,
                            framework_id: $('#framework option:selected').val()
                        },
                        dataType: 'json',
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message("'" + number + "' deleted successfully.", 'success');
                            $('#table_respondent_attributes').DataTable().ajax.reload(function () {
                            }, true);

                        } else {
                            //hide_loading_message();
                            show_message('Cancel request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Cancel request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });

    function refreshFrameworkSelect(){
        var csrf_token = $('meta[name="csrf-token"]').attr('content');
        var request = $.ajax({
            url: '/' + subdir + '/framework/get_framework_list/f/' + framework_id,
            cache: false,
            data: {
                id: 1,
                csrf_token: csrf_token,
            },
            dataType: 'json',
            type: 'POST'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#framework').empty();
                $('#framework').append($('<option>', {value: 0, text: "Select Framework"}));
                $.each(output.data[0], function (key, val) {
                    $('#framework').append($('<option>', {
                        value: val['id'],
                        text: val['framework_name']
                    }));
                });
            } else {
                hide_loading_message();
                show_message('Information request failed 1', 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed 2: ' + textStatus, 'warning');
        });
    }

// Add report button
    $(document).on('click', '#add_report', function (e) {
        e.preventDefault();
        $('#form_framework').hide();
        $('#form_survey').hide();
        $('#form_reports').show();
        $('#form_resp_attributes').hide();
        $('#form_question_codes').hide();
        $('.lightbox_content h2').text('Add Framework Report');
        $('#form_reports button').html('Add Report <i class="icon-arrow-right14 position-right"></i>');
        $('#form_reports').attr('class', 'form add');
        $('#form_reports .field_container label.error').hide();
        $('#form_reports .field_container').removeClass('valid').removeClass('error');
        $('#form_reports #file_output').val('');
        $('#form_reports #script_name').val('');
        $('#form_reports #report_name').val('');
        $('#form_reports #report_type').val('');

        hide_loading_message();
        show_lightbox();
    });
// Add report submit form
    $(document).on('submit', '#form_reports.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_reports.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_reports').serialize();

            var request = $.ajax({
                url: '/' + subdir + '/framework/add_framework_report/f/' + framework_id,
                cache: false,
                // data: form_data + '&id=1' + '&framework_id=' + $('#framework option:selected').val(),
                data: form_data + '&' + $.param({'id': 1}) + '&' + $.param({'framework_id': $('#framework option:selected').val()}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Report added successfully", 'success');
                    $('#table_framework_reports').DataTable().ajax.reload(function () {
                    }, true);
                } else {
                    hide_loading_message();
                    show_message(output.result, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });
// Edit report button
    $(document).on('click', '.function_edit_report a', function (e) {
        e.preventDefault();
        // Get company information from database
        //show_loading_message();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/framework/get_framework_report/f/' + framework_id,
            cache: false,
            data: 'id=' + id + '&framework_id=' + $('#framework option:selected').val(),
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#form_framework').hide();
                $('#form_survey').hide();
                $('#form_reports').show();
                $('#form_resp_attributes').hide();
                $('#form_question_codes').hide();
                var framework_id = output.data[0].id;
                $('.lightbox_content h2').text('Edit Framework Report');
                $('#form_reports button').html('Edit Report <i class="icon-arrow-right14 position-right"></i>');
                $('#form_reports').attr('class', 'form edit');
                $('#form_reports').attr('data-id', id);
                $('#form_reports').attr('data-name', output.data[0].framework_name);
                $('#form_reports .field_container label.error').hide();
                $('#form_reports .field_container').removeClass('valid').removeClass('error');
                $('#form_reports #script_name').val(output.data[0].script_name);
                $('#form_reports #report_name').val(output.data[0].report_name);
                $('#form_reports #report_type').val(output.data[0].report_type);
                $('#form_reports #file_output').val(output.data[0].file_output);

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

// Edit survey submit form
    $(document).on('submit', '#form_reports.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_reports.valid() == true) {
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_reports').attr('data-id');
            var form_data = $('#form_reports').serialize();
            var request = $.ajax({
                url: '/' + subdir + '/framework/edit_framework_report/f/' + framework_id,
                cache: false,
                // data: form_data + '&id=' + id + '&framework_id=' + $('#framework option:selected').val(),
                data: form_data + '&' + $.param({'id': id}) + '&' + '&' + $.param({'framework_id': $('#framework option:selected').val()}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Report edited successfully.", 'success');
                    $('#table_framework_reports').DataTable().ajax.reload(function () {
                    }, true);
                } else {
                    hide_loading_message();
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

//delete resport
    $(document).on('click', '.function_delete_report a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var name = $(this).data('name');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete '" + name + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/framework/delete_framework_report/f/' + framework_id,
                        // data: $.param({'id': id}) + '&' + $.param({'csrf_token': csrf_token}) + '&' + $.param({'framework_id': $('#framework option:selected').val()}),
                        data: {
                            id: id,
                            csrf_token: csrf_token,
                            framework_id: $('#framework option:selected').val()
                        },
                        cache: false,
                        dataType: 'json',
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message("'" + name + "' deleted successfully.", 'success');
                            $('#table_framework_reports').DataTable().ajax.reload(function () {
                                //hide_loading_message();
                            }, true);
                        } else {
                            //hide_loading_message();
                            show_message('Cancel request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Cancel request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });


//question codes

// Add resp attribute button
    $(document).on('click', '#add_question', function (e) {
        e.preventDefault();
        $('#form_framework').hide();
        $('#form_survey').hide();
        $('#form_reports').hide();
        $('#form_resp_attributes').hide();
        $('#form_question_codes').show();
        $('.lightbox_content h2').text('Add Question Code');
        $('#form_question_codes button').html('Add Question Code <i class="icon-arrow-right14 position-right"></i>');
        $('#form_question_codes').attr('class', 'form add');
        $('#form_question_codes .field_container label.error').hide();
        $('#form_question_codes .field_container').removeClass('valid').removeClass('error');
        $('#form_question_codes #value').val('');
        $('#form_question_codes #code').val('');
        $('#form_question_codes #type').val('');

        hide_loading_message();
        show_lightbox();
    });

// Add resp attribute submit form
    $(document).on('submit', '#form_question_codes.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_question_codes.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_question_codes').serialize();

            var request = $.ajax({
                url: '/' + subdir + '/framework/add_framework_question_code/f/' + framework_id,
                cache: false,
                // data: form_data + '&id=1' + '&framework_id=' + $('#framework option:selected').val(),
                data: form_data + '&' + $.param({'id': 1}) + '&' + $.param({'framework_id': $('#framework option:selected').val()}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Question Code added successfully", 'success');
                    $('#table_framework_question_codes').DataTable().ajax.reload(function () {
                    }, false);
                } else {
                    hide_loading_message();
                    show_message(output.result, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

// Edit resp attributes button
    $(document).on('click', '.function_edit_question_code a', function (e) {
        e.preventDefault();
        // Get company information from database
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/framework/get_framework_question_code/f/' + framework_id,
            cache: false,
            data: 'id=' + id + '&framework_id=' + $('#framework option:selected').val(),
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#form_framework').hide();
                $('#form_survey').hide();
                $('#form_reports').hide();
                $('#form_resp_attributes').hide();
                $('#form_question_codes').show();
                $('.lightbox_content h2').text('Edit Question Code');
                $('#form_question_codes button').html('Edit Question Code <i class="icon-arrow-right14 position-right"></i>');
                $('#form_question_codes').attr('class', 'form edit');
                $('#form_question_codes').attr('data-id', id);
                $('#form_question_codes .field_container label.error').hide();
                $('#form_question_codes .field_container').removeClass('valid').removeClass('error');
                $('#form_question_codes #value').val(output.data[0].value);
                $('#form_question_codes #code').val(output.data[0].code);
                $('#form_question_codes #type').val(output.data[0].type);

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

// Edit survey submit form
    $(document).on('submit', '#form_question_codes.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_question_codes.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_question_codes').attr('data-id');
            var form_data = $('#form_question_codes').serialize();
            var request = $.ajax({
                url: '/' + subdir + '/framework/edit_framework_question_code/f/' + framework_id,
                cache: false,
                // data: form_data + '&id=' + id + '&framework_id=' + $('#framework option:selected').val(),
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'framework_id': $('#framework option:selected').val()}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Attribute edited successfully.", 'success');
                    $('#table_framework_question_codes').DataTable().ajax.reload(function () {
                    }, false);
                } else {
                    hide_loading_message();
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

//delete question code
    $(document).on('click', '.function_delete_question_code a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var code = $(this).data('code');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete '" + code + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/framework/delete_framework_question_code/f/' + framework_id,
                        cache: false,
                        // data: $.param({'id': id}) + '&' + $.param({'code': code}) + '&' + $.param({'csrf_token': csrf_token}) + '&' + $.param({'framework_id': $('#framework option:selected').val()}),
                        data: {
                            id: id,
                            code: code,
                            csrf_token: csrf_token,
                            framework_id: $('#framework option:selected').val()
                        },
                        dataType: 'json',
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message("'" + code + "' deleted successfully.", 'success');
                            $('#table_framework_question_codes').DataTable().ajax.reload(function () {
                                //hide_loading_message();
                            }, false);
                        } else {
                            //hide_loading_message();
                            show_message('Cancel request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Cancel request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });

//delete framework
    $(document).on('click', '.function_delete_framework a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var name = $(this).data('name');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete '" + name + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/framework/delete_framework/f/' + framework_id,
                        // data: '&id=' + id + '&name=' + name + '&csrf_token=' + encodeURIComponent(csrf_token), //data: form_data + '&' + $.param({'myReportingGroups': json_arr}) + '&' + $.param({'csrf_token': csrf_token})
                        // data: id + '&' + $.param({'name': name}) + '&' + $.param({'csrf_token': csrf_token}),
                        data: {
                            id: id,
                            csrf_token: csrf_token,
                            name: name
                        },
                        cache: false,
                        dataType: 'json',
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message("'" + name + "' deleted successfully.", 'success');
                            $('#table_frameworks').DataTable().ajax.reload(function () {
                                //hide_loading_message();
                            }, true);
                        } else {
                            //hide_loading_message();
                            show_message('Cancel request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Cancel request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });


//copy framework
    $(document).on('click', '.function_copy_framework a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var name = $(this).data('name');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to copy '" + name + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/framework/copy_framework/f/' + framework_id,
                        cache: false,
                        // data: 'id=' + id + '&name=' + name,
                        data: {
                            id: id,
                            csrf_token: csrf_token,
                            name: name
                        },
                        dataType: 'json',
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message("'" + name + "' copied successfully, new name: " + name + "_copy", 'success');
                            $('#table_frameworks').DataTable().ajax.reload(function () {
                                //hide_loading_message();
                            }, true);
                        } else {
                            //hide_loading_message();
                            show_message('Copy request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('copy request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });


    $(document).on('change', ':file', function () {
        var input = $(this),
            numFiles = input.get(0).files ? input.get(0).files.length : 1,
            label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
        input.trigger('fileselect', [numFiles, label]);
    });
    $(':file').on('fileselect', function (event, numFiles, label) {

        var input = $(this).parents('.input-group').find(':text'),
            log = numFiles > 1 ? numFiles + ' files selected' : label;

        if (input.length) {
            input.val(log);
        } else {
            if (log) alert(log);
        }

    });
    $(document).on('click', '#importSubmit', function () {
        show_loading_message();
    });

//tooltips for tables
    $('[data-toggle="tooltip"]').tooltip({});


    $('#framework').change(function () {
        $('#table_framework_surveys').DataTable().ajax.reload(null, true);
        $('#table_framework_reports').DataTable().ajax.reload(null, true);
        $('#table_framework_question_codes').DataTable().ajax.reload(null, true);
        $('#table_respondent_attributes').DataTable().ajax.reload(null, true);
        $('#selected_framework_id').val($('#framework').val());  //for bulk import
    });

    $('#selected_framework_id').val($('#framework').val());  //for bulk import

    $('#activetype').change(function () {
        $('#table_frameworks').DataTable().ajax.reload(null, true);
    });

    $('#showcancelled').change(function () {
        $('#table_frameworks').DataTable().ajax.reload(null, true);
    });

//hide search option for yes/no drop downs
    $('#showcancelled').select2({
        minimumResultsForSearch: -1
    });
    $('#activetype').select2({
        minimumResultsForSearch: -1
    });




});
