$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var thisdir = params[1] + '/' + params[2];  //get subfolder (if any) that page is running from and page name
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f') {
            framework_id = params[i + 1];
        }
    }

    // On page load: datatable
    var table_report_category_groups = $('#table_report_category_groups').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/report_content/get_report_category_groups/f/' + framework_id,
            "data": function (d) {
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "code"},
            {"data": "display_order"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });


    var table_report_attributes = $('#table_report_attributes').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/report_content/get_report_attributes/f/' + framework_id,
            "data": function (d) {
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "attribute_code"},
            {"data": "value"},
            {"data": "category_code"},
            {"data": "category_name"},
            {"data": "display_order"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });

    var table_report_categories = $('#table_report_categories').DataTable({
        //"ajax": "./includes/frameworkdata.php?job=get_frameworks",
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/report_content/get_report_categories/f/' + framework_id,
            "data": function (d) {
                d.framework_id = $('#framework option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "code"},
            {"data": "name"},
            {"data": "type"},
            {"data": "display_order"},
            {"data": "parent_category_name"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });

    var table_report_questions = $('#table_report_questions').DataTable({
        //"ajax": "./includes/frameworkdata.php?job=get_frameworks",
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/report_content/get_report_questions/f/' + framework_id,
            "data": function (d) {
                d.framework_id = $('#framework option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "code"},
            {"data": "text"},
            {"data": "alt_text"},
            {"data": "report_question_type"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });


    var table_report_category_questions = $('#table_report_category_questions').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/report_content/get_report_question_categories/f/' + framework_id,
            "data": function (d) {
                d.framework_id = $('#framework option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "question_code"},
            {"data": "question_text"},
            {"data": "category_code"},
            {"data": "category_name"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });
    /*
     * ERROR HANDLING
     */

    $.fn.dataTable.ext.errMode = 'none';

    $('#table_frameworks')
        .on('error.dt', function (e, settings, techNote, message) {
            console.log('An error has been reported by DataTables: ', message);
        })
        .DataTable();


// On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            uname: {
                required: true,
                //checkUserName: true
            },
            password: {
                minlength: 3
            },
            confirm_password: {
                minlength: 3,
                equalTo: "#password"
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });
    var form_report_category = $('#form_report_category');
    form_report_category.validate();
    var form_report_category_group = $('#form_report_category_group');
    form_report_category_group.validate();
    var form_report_question = $('#form_report_question');
    form_report_question.validate();
    var form_question_categories = $('#form_question_categories');
    form_question_categories.validate();
    var form_report_attributes = $('#form_report_attributes');
    form_report_attributes.validate();

    //manually fade out alert (from bulk import)
    setTimeout(function () {
        $('.alert').fadeOut('slow');
    }, 3000);

// Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

// Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

// Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

// Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768) {
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset);
            yloc = yloc - 40;
            $('.lightbox_container').css('top', yloc + 'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

// Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

// Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
// Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
// Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

// Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }

    $("#addFrameworkSurvey").click(function () {
        $("#framework_surveys").append("<tr><td>row</td><td><input type='text'></td></tr>");
    });

    /**
     * Report Category Groups
     */

    $(document).on('click', '#add_report_category_group', function (e) {
        e.preventDefault();

        $('#form_report_category_group').show();
        $('#form_report_category').hide();
        $('#form_report_question').hide();
        $('#form_question_categories').hide();
        $('#form_report_attributes').hide();


        $('.lightbox_content h2').text('Add Report Category Group');
        $('#form_report_category_group button').html('Add Category Group <i class="icon-arrow-right14 position-right"></i>');

        $('#form_report_category_group #group_code').val('');
        $('#form_report_category_group #group_display_order').val(0);

        show_lightbox();
        $('#form_report_category_group #group_code').focus();
    });

    $(document).on('submit', '#form_report_category_group.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_report_category_group.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_report_category_group').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');

            var request = $.ajax({
                url: '/' + subdir + '/report_content/add_report_category_group/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Category Group added successfully", 'success');
                    $('#table_report_category_groups').DataTable().ajax.reload(function () {
                    });
                } else {
                    hide_loading_message();
                    show_message(output.result, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

    $(document).on('click', '.function_edit_category_group a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/report_content/get_report_category_groups/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('#form_report_category_group').show();
                $('#form_report_category').hide();
                $('#form_report_question').hide();
                $('#form_question_categories').hide();
                $('#form_report_attributes').hide();

                $('.lightbox_content h2').text('Edit Category Group');
                $('#form_report_category_group button').html('Edit Category Group <i class="icon-arrow-right14 position-right"></i>');
                $('#form_report_category_group').attr('class', 'form edit');
                $('#form_report_category_group').attr('data-id', id);
                $('#form_report_category_group .field_container label.error').hide();
                $('#form_report_category_group .field_container').removeClass('valid').removeClass('error');
                $('#form_report_category_group #group_code').val(output.data[0].code);
                $('#form_report_category_group #group_display_order').val(output.data[0].display_order);

                hide_loading_message();
                show_lightbox();
                $('#form_report_category_group #group_code').focus();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

    $(document).on('submit', '#form_report_category_group.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_report_category_group.valid() == true) {
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_report_category_group').attr('data-id');
            var form_data = $('#form_report_category_group').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var request = $.ajax({
                url: '/' + subdir + '/report_content/edit_report_category_group/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_report_category_groups').DataTable().ajax.reload(function () {
                        show_message("Category Group edited successfully.", 'success');
                    }, true);
                } else {
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
                hide_loading_message();
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

    $(document).on('click', '.function_delete_category_group a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var code = $(this).data('code');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete '" + code + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/report_content/delete_report_category_group/f/' + framework_id,
                        cache: false,
                        data: {
                            id: id,
                            csrf_token: csrf_token
                        },
                        dataType: 'json',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message("'" + code + "' deleted successfully.", 'success');
                            $('#table_report_category_groups').DataTable().ajax.reload(function () {
                            }, true);

                        } else {
                            //hide_loading_message();
                            show_message('Cancel request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Cancel request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });




    /**
     * Report Categories
     */

    $(document).on('click', '#add_report_category', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var request = $.ajax({
            // url:          '/' + dir + '/get_rounds/',
            url: '/' + subdir + '/report_content/get_report_details/f/' + framework_id,
            cache: false,
            data: 'id=1',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Add Category');
                $('#form_report_category button').html('Add Category <i class="icon-arrow-right14 position-right"></i>');
                $('#form_report_category').attr('class', 'form add');

                $('#form_report_category_group').hide();
                $('#form_report_category').show();
                $('#form_report_question').hide();
                $('#form_question_categories').hide();


                $('.lightbox_content h2').text('Add Report Category');
                $('#form_report_category button').html('Add Category <i class="icon-arrow-right14 position-right"></i>');

                $('#form_report_category #category_code').val('');
                $('#form_report_category #category_name').val('');
                $('#form_report_category #category_short_name').val('');
                $('#form_report_category #category_split_name').val('');
                $('#form_report_category #category_desc').val('');
                $('#form_report_category #category_short_desc').val('');
                $('#form_report_category #category_display_order').val(0);
                $('#form_report_category #hex_color').val('');
                $('#form_report_category #rgb_color').val('');


                $('#form_report_category #category_type').empty();

                var parser = new DOMParser;
                $.each(output.data.category_types, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    $('#form_report_category #category_type').append($('<option>', {
                        value: val['id'],
                        text: decodedString
                    }));
                });

                $('#form_report_category #parent_category_id').empty();
                $('#form_report_category #parent_category_id').append('<option value = "0" selected="selected">None</option>');

                var parser = new DOMParser;
                $.each(output.data.categories, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['name'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    $('#form_report_category #parent_category_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString
                    }));
                });

                $('#form_report_category #category_group_id').empty();
                $('#form_report_category #category_group_id').append('<option value = "0" selected="selected">None</option>');
                $.each(output.data.category_groups, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    $('#form_report_category #category_group_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString
                    }));
                });

                show_lightbox();
                $('#form_report_category #category_code').focus();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'warning');
        });

    });

    $(document).on('submit', '#form_report_category.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_report_category.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_report_category').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');

            var request = $.ajax({
                url: '/' + subdir + '/report_content/add_report_category/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Category added successfully", 'success');
                    $('#table_report_categories').DataTable().ajax.reload(function () {
                    });
                    $('#table_report_attributes').DataTable().ajax.reload(function () {
                    });
                } else {
                    hide_loading_message();
                    show_message(output.result, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

    $(document).on('click', '.function_edit_category a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/report_content/get_report_categories/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Edit Category');
                $('#form_report_category button').html('Edit Category <i class="icon-arrow-right14 position-right"></i>');
                $('#form_report_category').attr('class', 'form edit');
                $('#form_report_category').attr('data-id', id);

                $('#form_report_category_group').hide();
                $('#form_report_category').show();
                $('#form_report_question').hide();
                $('#form_question_categories').hide();
                $('#form_report_attributes').hide();

                $('.lightbox_content h2').text('Edit Report Category');
                $('#form_report_category button').html('Edit Category <i class="icon-arrow-right14 position-right"></i>');

                $('#form_report_category #category_code').val(output.data[0].code);
                $('#form_report_category #category_name').val(output.data[0].name);
                $('#form_report_category #category_short_name').val(output.data[0].short_name);
                $('#form_report_category #category_split_name').val(output.data[0].split_name);
                $('#form_report_category #category_display_order').val(output.data[0].display_order);
                $('#form_report_category #hex_color').val(output.data[0].hex_color);
                $('#form_report_category #rgb_color').val(output.data[0].rgb_color);

                $('#form_report_category #category_desc').val(output.data[0].category_desc);
                $('#form_report_category #category_short_desc').val(output.data[0].short_desc);

                $('#form_report_category #category_type').empty();

                var parser = new DOMParser;
                $.each(output.data[0].category_types, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    var isSelected = false;
                    if (val['id'] == output.data[0].parent_category_id) isSelected = true;
                    $('#form_report_category #category_type').append($('<option>', {
                        value: val['id'],
                        text: decodedString,
                        selected: isSelected
                    }));
                });

                $('#form_report_category #parent_category_id').empty();
                $('#form_report_category #parent_category_id').append('<option value = "0" >None</option>');

                var parser = new DOMParser;
                $.each(output.data[0].all_categories, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['name'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    var isSelected = false;
                    if (val['id'] == output.data[0].parent_category_id) isSelected = true;
                    $('#form_report_category #parent_category_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString,
                        selected: isSelected
                    }));
                });

                $('#form_report_category #category_group_id').empty();
                $('#form_report_category #category_group_id').append('<option value = "0" >None</option>');
                $.each(output.data[0].category_groups, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    var isSelected = false;
                    if (val['id'] == output.data[0].report_category_group_id) isSelected = true;
                    $('#form_report_category #category_group_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString,
                        selected: isSelected
                    }));
                });

                show_lightbox();
                $('#form_report_category #category_code').focus();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

    $(document).on('submit', '#form_report_category.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_report_category.valid() == true) {
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_report_category').attr('data-id');
            var form_data = $('#form_report_category').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var request = $.ajax({
                url: '/' + subdir + '/report_content/edit_report_category/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    show_message("Category edited successfully.", 'success');
                    $('#table_report_categories').DataTable().ajax.reload(function () {
                    }, false);
                    $('#table_report_category_questions').DataTable().ajax.reload(function () {
                    }, false);
                } else {
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
                hide_loading_message();
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

    $(document).on('click', '.function_delete_category a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var code = $(this).data('code');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete '" + code + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/report_content/delete_report_category/f/' + framework_id,
                        cache: false,
                        data: {
                            id: id,
                            csrf_token: csrf_token
                        },
                        dataType: 'json',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message("'" + code + "' deleted successfully.", 'success');
                            $('#table_report_categories').DataTable().ajax.reload(function () {
                            }, true);

                        } else {
                            //hide_loading_message();
                            show_message('Delete request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Delete request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });




    /**
     * Report Questions
     */

    $(document).on('click', '#add_report_question', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var request = $.ajax({
            // url:          '/' + dir + '/get_rounds/',
            url: '/' + subdir + '/report_content/get_report_details/f/' + framework_id,
            cache: false,
            data: 'id=1',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Add Question');
                $('#form_report_question button').html('Add Question <i class="icon-arrow-right14 position-right"></i>');
                $('#form_report_question').attr('class', 'form add');

                $('#form_report_category_group').hide();
                $('#form_report_category').hide();
                $('#form_report_question').show();
                $('#form_question_categories').hide();
                $('#form_report_attributes').hide();


                $('.lightbox_content h2').text('Add Question');
                $('#form_report_question button').html('Add Question <i class="icon-arrow-right14 position-right"></i>');

                $('#form_report_question #question_code').val('');
                $('#form_report_question #question_text').val('');
                $('#form_report_question #question_alt_text').val('');
                $('#form_report_question #question_short_text').val('');
                $('#form_report_question #question_split_text').val('');


                $('#form_report_question #question_type').empty();

                var parser = new DOMParser;
                $.each(output.data.question_types, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    $('#form_report_question #question_type').append($('<option>', {
                        value: val['id'],
                        text: decodedString
                    }));
                });

                show_lightbox();
                $('#form_report_question #question_code').focus();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'warning');
        });

    });

    $(document).on('submit', '#form_report_question.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_report_question.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_report_question').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');

            var request = $.ajax({
                url: '/' + subdir + '/report_content/add_report_question/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message("Question added successfully", 'success');
                    $('#table_report_questions').DataTable().ajax.reload(function () {
                    });
                } else {
                    hide_loading_message();
                    show_message(output.result, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

    $(document).on('click', '.function_edit_report_question a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/report_content/get_report_questions/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {

                $('.lightbox_content h2').text('Edit Question');
                $('#form_report_question button').html('Edit Question <i class="icon-arrow-right14 position-right"></i>');
                $('#form_report_question').attr('class', 'form edit');
                $('#form_report_question').attr('data-id', id);

                $('#form_report_category_group').hide();
                $('#form_report_category').hide();
                $('#form_report_question').show();
                $('#form_question_categories').hide();
                $('#form_report_attributes').hide();


                $('#form_report_question #question_code').val(output.data[0].code);
                $('#form_report_question #question_text').val(output.data[0].text);
                $('#form_report_question #question_alt_text').val(output.data[0].alt_text);
                $('#form_report_question #question_short_text').val(output.data[0].short_text);
                $('#form_report_question #question_split_text').val(output.data[0].split_text);

                $('#form_report_question #question_type').empty();
                var parser = new DOMParser;
                $.each(output.data[0].all_question_types, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    var isSelected = false;
                    if (val['id'] == output.data[0].report_question_type_id) isSelected = true;
                    $('#form_report_question #question_type').append($('<option>', {
                        value: val['id'],
                        text: decodedString,
                        selected: isSelected
                    }));
                });

                show_lightbox();
                $('#form_report_question #question_code').focus();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

    $(document).on('submit', '#form_report_question.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_report_question.valid() == true) {
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_report_question').attr('data-id');
            var form_data = $('#form_report_question').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var request = $.ajax({
                url: '/' + subdir + '/report_content/edit_report_question/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    show_message("Question edited successfully.", 'success');
                    $('#table_report_questions').DataTable().ajax.reload(function () {
                    }, false);
                    $('#table_report_category_questions').DataTable().ajax.reload(function () {
                    }, false);
                } else {
                    show_message('Edit request failed: ' + output['message'], 'danger');
                }
                hide_loading_message();
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

    $(document).on('click', '.function_delete_report_question a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var code = $(this).data('code');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete '" + code + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/report_content/delete_report_question/f/' + framework_id,
                        cache: false,
                        data: {
                            id: id,
                            csrf_token: csrf_token
                        },
                        dataType: 'json',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message("'" + code + "' deleted successfully.", 'success');
                            $('#table_report_questions').DataTable().ajax.reload(function () {
                            }, true);

                        } else {
                            //hide_loading_message();
                            show_message('Delete request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Delete request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });






    /**
     * Report Question Categories
     */

    $(document).on('click', '#add_report_question_categories', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var request = $.ajax({
            // url:          '/' + dir + '/get_rounds/',
            url: '/' + subdir + '/report_content/get_report_details/f/' + framework_id,
            cache: false,
            data: 'id=1',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Add Question Category');
                $('#form_question_categories button').html('Add Question Category <i class="icon-arrow-right14 position-right"></i>');
                $('#form_question_categories').attr('class', 'form add');

                $('#form_report_category_group').hide();
                $('#form_report_category').hide();
                $('#form_report_question').hide();
                $('#form_question_categories').show();
                $('#form_report_attributes').hide();

                $('#form_question_categories #report_question_id').empty();

                var parser = new DOMParser;
                $.each(output.data.questions, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'] + ': ' + val['text'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    $('#form_question_categories #report_question_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString
                    }));
                });

                $('#form_question_categories #report_category_id').empty();

                var parser = new DOMParser;
                $.each(output.data.categories, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'] + ': ' + val['name'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    $('#form_question_categories #report_category_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString
                    }));
                });

                $('#form_question_categories #question_category_display_order').val(0);
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'warning');
        });

    });

    $(document).on('submit', '#form_question_categories.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_question_categories.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_question_categories').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');

            var request = $.ajax({
                url: '/' + subdir + '/report_content/add_report_question_category/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message(output.message, 'success');
                    $('#table_report_category_questions').DataTable().ajax.reload(function () {
                    });
                } else {
                    hide_loading_message();
                    show_message(output.message, 'warning');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'warning');
            });
        }
    });

    $(document).on('click', '.function_edit_question_category a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/report_content/get_report_question_categories/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {

                $('.lightbox_content h2').text('Edit Question');
                $('#form_question_categories button').html('Edit Question Category<i class="icon-arrow-right14 position-right"></i>');
                $('#form_question_categories').attr('class', 'form edit');
                $('#form_question_categories').attr('data-id', id);

                $('#form_report_category_group').hide();
                $('#form_report_category').hide();
                $('#form_report_question').hide();
                $('#form_question_categories').show();
                $('#form_report_attributes').hide();


                $('#form_question_categories #report_question_id').empty();

                var parser = new DOMParser;
                $.each(output.data[0].all_questions, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'] + ': ' + val['text'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    var isSelected = false;
                    if (val['id'] == output.data[0].question_id) isSelected = true;
                    $('#form_question_categories #report_question_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString,
                        selected: isSelected
                    }));
                });

                $('#form_question_categories #report_category_id').empty();

                var parser = new DOMParser;
                $.each(output.data[0].all_categories, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'] + ': ' + val['name'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    var isSelected = false;
                    if (val['id'] == output.data[0].category_id) isSelected = true;
                    $('#form_question_categories #report_category_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString,
                        selected: isSelected
                    }));
                });

                $('#form_question_categories #question_category_display_order').val(output.data[0].display_order);

                show_lightbox();

            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

    $(document).on('submit', '#form_question_categories.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_question_categories.valid() == true) {
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_question_categories').attr('data-id');
            var form_data = $('#form_question_categories').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var request = $.ajax({
                url: '/' + subdir + '/report_content/edit_report_question_category/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    show_message(output.message, 'success');
                    $('#table_report_category_questions').DataTable().ajax.reload(function () {
                    }, true);
                } else {
                    show_message(output.message, 'warning');
                }
                hide_loading_message();
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

    $(document).on('click', '.function_delete_question_category a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var code = $(this).data('qcode');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete this entry for '" + code + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/report_content/delete_report_question_category/f/' + framework_id,
                        cache: false,
                        data: {
                            id: id,
                            csrf_token: csrf_token
                        },
                        dataType: 'json',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message("Question-Category deleted successfully.", 'success');
                            $('#table_report_category_questions').DataTable().ajax.reload(function () {
                            }, true);

                        } else {
                            //hide_loading_message();
                            show_message('Delete request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Delete request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });




    /**
     * Report Attributes
     */

    $(document).on('click', '#add_report_attribute', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var request = $.ajax({
            // url:          '/' + dir + '/get_rounds/',
            url: '/' + subdir + '/report_content/get_report_details/f/' + framework_id,
            cache: false,
            data: 'id=1',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Add Category Attribute');
                $('#form_report_attributes button').html('Add Category Attribute <i class="icon-arrow-right14 position-right"></i>');
                $('#form_report_attributes').attr('class', 'form add');

                $('#form_report_category_group').hide();
                $('#form_report_category').hide();
                $('#form_report_question').hide();
                $('#form_question_categories').hide();
                $('#form_report_attributes').show();

                $('#form_report_attributes #report_attribute_type_id').empty();

                var parser = new DOMParser;
                $.each(output.data.attribute_types, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'] + ': ' + val['description'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    $('#form_report_attributes #report_attribute_type_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString
                    }));
                });

                $('#form_report_attributes #attribute_category_id').empty();

                var parser = new DOMParser;
                $.each(output.data.categories, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'] + ': ' + val['name'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    $('#form_report_attributes #attribute_category_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString
                    }));
                });

                $('#form_report_attributes #report_attribute_value').val('');

                $('#form_report_attributes #attribute_display_order').val(0);
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'warning');
        });

    });

    $(document).on('submit', '#form_report_attributes.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_report_attributes.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_report_attributes').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');

            var request = $.ajax({
                url: '/' + subdir + '/report_content/add_report_attribute/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    hide_loading_message();
                    show_message(output.message, 'success');
                    $('#table_report_attributes').DataTable().ajax.reload(function () {
                    });
                } else {
                    hide_loading_message();
                    show_message(output.message, 'warning');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'warning');
            });
        }
    });

    $(document).on('click', '.function_edit_attribute a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/report_content/get_report_attributes/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {

                $('.lightbox_content h2').text('Edit Category Attribute');
                $('#form_report_attributes button').html('Edit Category Attribute <i class="icon-arrow-right14 position-right"></i>');
                $('#form_report_attributes').attr('class', 'form edit');
                $('#form_report_attributes').attr('data-id', id);

                $('#form_report_category_group').hide();
                $('#form_report_category').hide();
                $('#form_report_question').hide();
                $('#form_question_categories').hide();
                $('#form_report_attributes').show();

                $('#form_report_attributes #report_attribute_type_id').empty();

                var parser = new DOMParser;
                $.each(output.data[0].attribute_types, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'] + ': ' + val['description'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    var isSelected = false;
                    if (val['id'] == output.data[0].attribute_type_id) isSelected = true;
                    $('#form_report_attributes #report_attribute_type_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString,
                        selected: isSelected
                    }));
                });

                $('#form_report_attributes #attribute_category_id').empty();

                var parser = new DOMParser;
                $.each(output.data[0].all_categories, function (key, val) {
                    var dom = parser.parseFromString(
                        '<!doctype html><body>' + val['code'] + ': ' + val['name'],
                        'text/html');
                    var decodedString = dom.body.textContent;
                    var isSelected = false;
                    if (val['id'] == output.data[0].category_id) isSelected = true;
                    $('#form_report_attributes #attribute_category_id').append($('<option>', {
                        value: val['id'],
                        text: decodedString,
                        selected: isSelected
                    }));
                });

                $('#form_report_attributes #report_attribute_value').val(output.data[0].value);

                $('#form_report_attributes #attribute_display_order').val(output.data[0].display_order);
                show_lightbox();

            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

    $(document).on('submit', '#form_report_attributes.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_report_attributes.valid() == true) {
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_report_attributes').attr('data-id');
            var form_data = $('#form_report_attributes').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var request = $.ajax({
                url: '/' + subdir + '/report_content/edit_report_attribute/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id': id}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    show_message(output.message, 'success');
                    $('#table_report_attributes').DataTable().ajax.reload(function () {
                    });
                } else {
                    show_message(output.message, 'warning');
                }
                hide_loading_message();
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

    $(document).on('click', '.function_delete_attribute a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var code = $(this).data('code');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete this entry for '" + code + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/report_content/delete_report_attribute/f/' + framework_id,
                        cache: false,
                        data: {
                            id: id,
                            csrf_token: csrf_token
                        },
                        dataType: 'json',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message("Attribute deleted successfully.", 'success');
                            $('#table_report_attributes').DataTable().ajax.reload(function () {
                            });

                        } else {
                            //hide_loading_message();
                            show_message('Delete request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Delete request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });



//hide search option for yes/no drop downs
    $('#showcancelled').select2({
        minimumResultsForSearch: -1
    });
    $('#activetype').select2({
        minimumResultsForSearch: -1
    });


    $(document).on('change', ':file', function () {
        var input = $(this),
            numFiles = input.get(0).files ? input.get(0).files.length : 1,
            label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
        input.trigger('fileselect', [numFiles, label]);
    });


    $(':file').on('fileselect', function (event, numFiles, label) {

        var input = $(this).parents('.input-group').find(':text'),
            log = numFiles > 1 ? numFiles + ' files selected' : label;

        if (input.length) {
            input.val(log);
        } else {
            if (log) alert(log);
        }

    });
    setTimeout(function () {
        $('.alert').fadeOut('slow');
    }, 5000);


    // $(document).on('click', '#importSubmit', function () {
    //     event.preventDefault();
    //     show_loading_message();
    //     $("#importFrm").submit();
    // });


});
