var mychart;

$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];  //get subfolder (if any) that page is running from and page name
    var table_reports;
    var table_reports_id = "";
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }



    /*
    - on page load, show 'please select an option above' to select either round or participant
    - have round set to 'select' and participant set to 'select' -> if participant reports (could just be a group report), and if round reports (could be qualitative, no round/group report).
    - on round select, populate participant list if participant reports, and IF round reports, call for chart
    - on participant select, call for chart.

    foreach (category has display_report = 1) {

    }
     */

    mychart = new Highcharts.Chart({
        chart: {
            renderTo: 'container4',
            type: 'line',
            marginRight: 130,
            marginBottom: 25,
            events: {
                // load: requestData
            }
        },
        title: {
            text: 'Category Results',
            x: -20 //center
        },
        xAxis: {
            categories: [1,2,3,4,5]
        },
        yAxis: {
            title: {
                text: 'Average Score'
            },
            plotLines: [{
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        legend: {
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'top',
            x: -10,
            y: 100,
            borderWidth: 0
        },
        series: [
            {
                name: 'categories',
                data: []
            }
        ]
    });


    function requestData(round_id,participant_id) {
        $.ajax({
            url: '/' + subdir + '/charts/get_category_results/f/' + framework_id,
            type: "GET",
            dataType: "json",
            // data : {username : "demo"},
            data: 'round_id=' + round_id + '&participant_id='+participant_id,
            success: function(data) {
                mychart.addSeries({
                    name: "categories",
                    data: data.round_results
                });
            },
            cache: false
        });
        // "{"month_mentions_graphic":[521,49,81,0,101,0,0,0,21,3071,0,0,0,0,0,1479,6124,2409,2608,0,0,3457,2057,2580,5876,4638,0,0,3337,3479,430]}"
        // var request = $.ajax({
        //     url: '/' + subdir + '/participant_round_display/get_participants/f/' + framework_id,
        //     data: 'selectedround=' + round + '&openroundsonly=0',
        //     dataType: 'json',
        //     contentType: 'application/json; charset=utf-8',
        //     type: 'get'
        // });
    }

    function refreshParticipantList() {
        var round = $('#drop option:selected').val();
        var request = $.ajax({
            url: '/' + subdir + '/participant_round_display/get_participants/f/' + framework_id,
            data: 'selectedround=' + round + '&openroundsonly=0',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                var html = "<option value=\"0\" selected=\"selected\">All</option>";
                $.each(output.data, function (key, val) {
                    html += "<option value=" + val["id"] + ">" + val["fname"] + " " + val["lname"] + "</option>";

                });
                $('#selectparticipant').html(html);

            } else {
                // show_message('Information request failed', 'warning');
            }
        });
    }


    $('#drop').change(function () {
        $('#selectparticipant option:selected').val(0);
        refreshParticipantList();
        // clearCharts();
    });


    $('#selectparticipant').change(function () {

        var round = $('#drop option:selected').val();
        var participant_id = $('#selectparticipant option:selected').val(0);
        requestData(round,participant_id);
    });




    $(document).click(function() {
        $('.ui-tooltip').remove();
    });

    // Create the chart
    Highcharts.chart('container', {
        chart: {
            type: 'column'
        },
        title: {
            text: 'Category Summary - Click to drill down'
        },
        subtitle: {
            text: 'Click the columns to view versions. Source: <a href="http://statcounter.com" target="_blank">statcounter.com</a>'
        },
        xAxis: {
            type: 'category'
        },
        yAxis: {
            title: {
                text: 'Score'
            }

        },
        legend: {
            enabled: false
        },
        plotOptions: {
            series: {
                borderWidth: 0,
                dataLabels: {
                    enabled: true,
                    format: '{point.y:.1f}%'
                }
            }
        },

        tooltip: {
            headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
            pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.2f}%</b> of total<br/>'
        },

        "series": [
            {
                "name": "Browsers",
                "colorByPoint": true,
                "data": [
                    {
                        "name": "Chrome",
                        "y": 62.74,
                        "drilldown": "Chrome"
                    },
                    {
                        "name": "Firefox",
                        "y": 10.57,
                        "drilldown": "Firefox"
                    },
                    {
                        "name": "Internet Explorer",
                        "y": 7.23,
                        "drilldown": "Internet Explorer"
                    },
                    {
                        "name": "Safari",
                        "y": 5.58,
                        "drilldown": "Safari"
                    },
                    {
                        "name": "Edge",
                        "y": 4.02,
                        "drilldown": "Edge"
                    },
                    {
                        "name": "Opera",
                        "y": 1.92,
                        "drilldown": "Opera"
                    },
                    {
                        "name": "Other",
                        "y": 7.62,
                        "drilldown": null
                    }
                ]
            }
        ],
        "drilldown": {
            "series": [
                {
                    "name": "Chrome",
                    "id": "Chrome",
                    "data": [
                        [
                            "v65.0",
                            0.1
                        ],
                        [
                            "v64.0",
                            1.3
                        ],
                        [
                            "v63.0",
                            53.02
                        ],
                        [
                            "v62.0",
                            1.4
                        ],
                        [
                            "v61.0",
                            0.88
                        ],
                        [
                            "v60.0",
                            0.56
                        ],
                        [
                            "v59.0",
                            0.45
                        ],
                        [
                            "v58.0",
                            0.49
                        ],
                        [
                            "v57.0",
                            0.32
                        ],
                        [
                            "v56.0",
                            0.29
                        ],
                        [
                            "v55.0",
                            0.79
                        ],
                        [
                            "v54.0",
                            0.18
                        ],
                        [
                            "v51.0",
                            0.13
                        ],
                        [
                            "v49.0",
                            2.16
                        ],
                        [
                            "v48.0",
                            0.13
                        ],
                        [
                            "v47.0",
                            0.11
                        ],
                        [
                            "v43.0",
                            0.17
                        ],
                        [
                            "v29.0",
                            0.26
                        ]
                    ]
                },
                {
                    "name": "Firefox",
                    "id": "Firefox",
                    "data": [
                        [
                            "v58.0",
                            1.02
                        ],
                        [
                            "v57.0",
                            7.36
                        ],
                        [
                            "v56.0",
                            0.35
                        ],
                        [
                            "v55.0",
                            0.11
                        ],
                        [
                            "v54.0",
                            0.1
                        ],
                        [
                            "v52.0",
                            0.95
                        ],
                        [
                            "v51.0",
                            0.15
                        ],
                        [
                            "v50.0",
                            0.1
                        ],
                        [
                            "v48.0",
                            0.31
                        ],
                        [
                            "v47.0",
                            0.12
                        ]
                    ]
                },
                {
                    "name": "Internet Explorer",
                    "id": "Internet Explorer",
                    "data": [
                        [
                            "v11.0",
                            6.2
                        ],
                        [
                            "v10.0",
                            0.29
                        ],
                        [
                            "v9.0",
                            0.27
                        ],
                        [
                            "v8.0",
                            0.47
                        ]
                    ]
                },
                {
                    "name": "Safari",
                    "id": "Safari",
                    "data": [
                        [
                            "v11.0",
                            3.39
                        ],
                        [
                            "v10.1",
                            0.96
                        ],
                        [
                            "v10.0",
                            0.36
                        ],
                        [
                            "v9.1",
                            0.54
                        ],
                        [
                            "v9.0",
                            0.13
                        ],
                        [
                            "v5.1",
                            0.2
                        ]
                    ]
                },
                {
                    "name": "Edge",
                    "id": "Edge",
                    "data": [
                        [
                            "v16",
                            2.6
                        ],
                        [
                            "v15",
                            0.92
                        ],
                        [
                            "v14",
                            0.4
                        ],
                        [
                            "v13",
                            0.1
                        ]
                    ]
                },
                {
                    "name": "Opera",
                    "id": "Opera",
                    "data": [
                        [
                            "v50.0",
                            0.96
                        ],
                        [
                            "v49.0",
                            0.82
                        ],
                        [
                            "v12.1",
                            0.14
                        ]
                    ]
                }
            ]
        }
    });


    $(function () {

        var title_activities = "Activities",
            source_activities = "My source",
            link_activities = "http://www.highcharts.com",
            credits_databasis_str_activities = "215",
            activities_category_names = ["eat", "read", "surf in internet"],
            activities_category_data = [{y:66.15, drilldown:{name:"eat - How often?", data:[["1 time per day", 21], ["3 times per day", 45], ["2 times per day", 27], ["2 times a week", 3], ["≥ 3 times a week", 5], ["less", 4], ["every other week", 3], ["1 times a week", 7], ["not specified", 6], ["once a month", 6]]}}, {y:67.71, drilldown:{name:"read - How much time?", data:[["2h per day", 11], ["1h per day", 41], ["less often", 6], ["2h per week", 8], ["1/2h per day", 38], ["1h per week", 10], ["3h per week", 4], ["≥ 3h per day", 5], ["not specified", 7]]}}, {y:59.38, drilldown:{name:"surf in internet - How much time?", data:[["2h per day", 31], ["1h per week", 1], ["2h per week", 2], ["1h per day", 37], ["1/2h per day", 20], ["≥ 3h per day", 13], ["less often", 3], ["not specified", 5], ["3h per week", 2]]}}],
            room_filter_name = "Living Room"

        var colors = Highcharts.getOptions().colors,
            categories = activities_category_names,
            name = 'Activities',
            data = activities_category_data

        function setChart(chart, options) {

            var max = chart.series.length;
            for (var i = 0; i < max; i++) {
                chart.series[0].remove(false);
            }

            chart.xAxis[0].setCategories(options.categories, false);

            chart.addSeries({
                type: options.type,
                name: options.name,
                data: options.data,
                color: colors[0]
            }, false);

            chart.redraw();
        }

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: 'activities_chart',
                type: 'bar',
                spacingRight: 15
            },
            title: {
                text: title_activities
            },
            subtitle: {
                text: 'Current room: ' + room_filter_name
            },
            credits: {
                text: "Databasis: " + credits_databasis_str_activities + " households" + "    |    Source: " + source_activities,
                href: link_activities
            },
            xAxis: {
                categories: categories
            },
            yAxis: {
                title: {
                    text: null
                },
                max: 100
            },
            plotOptions: {
                bar: {
                    cursor: 'pointer',
                    point: {
                        events: {
                            click: function() {
                                var drilldown = this.drilldown;

                                this.series.chart.setTitle({
                                    text: "Activities - " + drilldown.name
                                });

                                var options = {
                                    'name': drilldown.name,
                                    'categories': drilldown.categories,
                                    'data': drilldown.data,
                                    'type': 'pie'
                                };

                                setChart(this.series.chart, options);
                            }
                        }
                    }
                },
                pie: {
                    cursor: 'pointer',
                    point: {
                        events: {
                            click: function() {
                                this.series.chart.setTitle({
                                    text: "Activities"
                                });
                                var options = {
                                    'name': name,
                                    'categories': categories,
                                    'data': data,
                                    'type': 'bar'
                                };

                                setChart(this.series.chart, options);
                            }
                        }
                    },
                    dataLabels: {
                        enabled: true,
                        color: colors[0],
                        connectorColor: colors[0],
                        distance: 15,
                        formatter: function() {
                            var label_String = this.point.name;

                            if (label_String.length > 16) {
                                label_String = label_String.substring(0,16) + "..."
                            };

                            return '<b>'+ label_String +'</b>: '+ this.y;
                        }
                    }
                }
            },
            tooltip: {
                formatter: function() {
                    var point = this.point,
                        s = ""

                    if (point.drilldown) {
                        s += this.x +':<b>'+ this.y +' % of households</b><br/>';
                        s += 'Click to view '+ point.category +' details';
                    } else {
                        s += point.name +':<b>'+ this.y +' times chosen</b><br/>';
                        s += 'Click to return to activities overview';
                    }
                    return s;
                }
            },
            series: [{
                type: 'bar',
                name: name,
                data: data
            }],
            exporting: {
                enabled: false
            }
        })
    }); //end


    var chart = Highcharts.chart('container2', {

        title: {
            text: 'Chart.update'
        },

        subtitle: {
            text: 'Plain'
        },

        xAxis: {
            categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
        },
        series: [{
            type: 'column',
            colorByPoint: true,
            data: [29.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1, 95.6, 54.4],
            showInLegend: false
        }]

    });


    $('#plain').click(function () {
        chart.update({
            chart: {
                inverted: false,
                polar: false
            },
            plotOptions: {
                column: {
                    groupPadding: .2
                }
            },
            subtitle: {
                text: 'Plain'
            }
        });
    });

    $('#inverted').click(function () {
        chart.update({
            chart: {
                inverted: true,
                polar: false
            },
            plotOptions: {
                column: {
                    groupPadding: .2
                }
            },
            subtitle: {
                text: 'Inverted'
            }
        });
    });

    $('#polar').click(function () {
        chart.update({
            chart: {
                inverted: false,
                polar: true
            },
            plotOptions: {
                column: {
                    pointPadding: 0,
                    groupPadding: 0
                }
            },
            subtitle: {
                text: 'Polar'
            }
        });
    });

    $(function () {

        window.chart = new Highcharts.Chart({

            chart: {
                renderTo: 'container3',
                polar: true
            },

            title: {
                text: 'Highcharts Polar Chart'
            },

            xAxis: {
                categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug']
            },

            yAxis: {
                min: 0
            },

            plotOptions: {
                column: {
                    pointPadding: 0,
                    groupPadding: 0
                }
            },

            series: [{
                type: 'column',
                name: 'Column',
                data: [8, 7, 6, 5, 4, 3, 2, 1],
            }]
        });
    });

});
