// if there was anything generic to all pages to do on load
var show_message;
var timeout_fn;
var tabFocusRestrictor;
var confirm_request;  //jquery ui dialog to replace confirmation
var alert;  //jquery ui dialog to replace alert

$(document).ready(function () {
    $(".select2-selection--single").each(function () {
        $(this).addClass("border-primary text-primary-700");
    });


    //add jQuery UI tooltip
    $(document).tooltip({show: null});
    //remove tooltip from select
    $(".select2-selection__rendered").removeAttr('title');

    //disable automcomplete for all forms
    $("form").attr('autocomplete', 'off');
    $("input").attr('autocomplete', 'off');
    $("select").attr('autocomplete', 'off');

    var yDiff = 0;
    // Show message
    show_message = function (message_text, message_type, message_timeout) {
        if (message_timeout === undefined) {
            message_timeout = 5000;
        }
        yDiff = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset);
        yDiff = yDiff - 40;
        $('#message_container').html('<div id="message" style="top: ' + yDiff + 'px;z-index: 900;"><div class="alert alert-' + message_type + ' alert-styled-left">' +
            '<button type="button" class="close" data-dismiss="alert" style="margin-top:-3px"><span  style="font-size:1.8rem;font-weight:500">×</span><span class="sr-only">Close</span></button>'
            + message_text + '</div></div>');
        $('#message_container').show();
        setTimeout(function () {
            $('#message_container').fadeOut('slow');
        }, message_timeout);
    }




    $(window).scroll(function () {
        yDiff = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset);
        yDiff = yDiff - 60;
        $('#message').animate({top: yDiff + "px"}, {queue: false, duration: 50});
    });

    $(document).on('focus', '.select2.select2-container', function (e) {
        // only open on original attempt - close focus event should not fire open
        if (e.originalEvent && $(this).find(".select2-selection--single").length > 0) {
            $(this).siblings('select').select2('open');
        }
    });
    $('input:checkbox').keypress(function(e){
        e.preventDefault;
        if((e.keyCode ? e.keyCode : e.which) == 13){
            $(this).trigger('click');
            return false;
        }
    });



    confirm_request = function (message) {
        //using jquery ui dialog to replace confirm message, have to handle the result differently than standard confirm (use $.when)
        $("#confirm_message").html(message);
        var def = $.Deferred();

        $("#confirm_message").dialog({
            resizable: false,
            autoOpen: false,
            height: 180,
            width: 480,
            modal: true,
            buttons: {
                "Confirm": function () {
                    $("#confirm_message").html("");
                    $(this).dialog("close");
                    def.resolve(1);
                },
                "Cancel": function () {
                    $("#confirm_message").html("");
                    $(this).dialog("close");
                    def.resolve(0);
                }
            }
        });
        $("#confirm_message").dialog("open");
        return def.promise();
    }

    alert = function (message) {
        $("#alert_message").html(message);
        $("#alert_message").dialog({
            resizable: false,
            autoOpen: false,
            height: 180,
            width: 400,
            modal: true,
            buttons: {
                "OK": function () {
                    $("#alert_message").html("");
                    $(this).dialog("close");
                }
            }
        });
        $("#alert_message").dialog("open");
    }

    confirm_refresh = function (message) {
        $("#refresh_message").html(message);
        $("#refresh_message").dialog({
            resizable: false,
            autoOpen: false,
            height: 180,
            width: 400,
            modal: true,
            buttons: {
                "OK": function () {
                    $("#refresh_message").html("");
                    window.location.reload();
                    $(this).dialog("close");
                }
            }
        });
        $("#refresh_message").addClass("timeout");
        $("#refresh_message").dialog("open");
    }

    if ($("#csrf_message").val() != "") {
        show_message($("#csrf_message").val(), 'danger');
    }

    function escapeHtml(unsafe) {
        return unsafe
            .replace(/&/g, "&amp;")
            .replace(/</g, "&lt;")
            .replace(/>/g, "&gt;")
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&#039;");
    }

    var current_page = $("#current_page").val();
    $("#" + current_page).addClass("active");  //the page menu link
    $("#" + current_page).parent().parent().addClass("active");   //the parent menu item  itself
    $("#" + current_page).parent().css("display", "block");

    if ($('body').width() < 1150) {
        // Toggle min sidebar class
        $('body').toggleClass('sidebar-xs');
    }


    $(document).on('click', '#admin_logout', function (e) {

        // alert('Please close this tab/window to log out and return to the admin screen');
        // window.close();
        var params = window.location.pathname.split('/');
        var subdir = params[1];
        window.location = "/" + subdir + "/close_user";
    });


    /**
     * Script to log out if no action for set number of minutes
     */
        //Increment the idle time counter every 60 seconds.
    var idleInterval = setInterval(timerIncrement, 60000); // 60 seconds

    var currentTime         = new Date();
    var loadTime = currentTime.getTime();
    localStorage.setItem("loadTime", loadTime); // current time is set to localStorage after  seconds (it is for setting in multiple tabs)

    $(document).on("click", function (e) {
        if (!e.isTrigger) {
            currentTime         = new Date();
            loadTime = currentTime.getTime();
            localStorage.setItem("loadTime", loadTime);
        }
    });

    function timerIncrement() {
        var active_time = $('#active_time').val() / 60; //session lifetime in minutes
        if (active_time == 0) active_time = 30; //logout after 30 minutes if other time not set

        d = new Date();
        loadTime = localStorage.getItem("loadTime");
        var currTime = d.getTime();
        var timeDiff = Math.round((currTime - loadTime) / (1000 * 60));

        if (timeDiff >= active_time) { // 20 minutes
            var params = window.location.pathname.split('/');
            var subdir = params[1];
            window.location = "/" + subdir + "/logged_out";
        } else if (timeDiff >= active_time - 1) {
            confirm_refresh("You have been inactive for " + timeDiff + " minutes and will be logged out automatically in 60 seconds.  Click 'OK' to cancel the logout and refresh the page.");
        } else {
            //hide alert if been clicked on another window/tab
            if ($("#refresh_message").hasClass("ui-dialog-content") &&
                $("#refresh_message").dialog("isOpen")) {
                $("#refresh_message").dialog("close");
            }
        }


    }


});